<?php

/*
 * --------------------------------------------------------------------------
 * Grafite CMS Config
 * --------------------------------------------------------------------------
*/

if (! function_exists('env')) {
    function env($key, $default)
    {
        return $default;
    }
}

return [

    /*
     * --------------------------------------------------------------------------
     * Revive Host Address
     * --------------------------------------------------------------------------
    */

    'host' => env('RVRPC_HOST', ''),

    /*
     * --------------------------------------------------------------------------
     * Path to api on host
     * --------------------------------------------------------------------------
    */

    'basepath' => env('RVRPC_BASEPATH', ''),

    /*
     * --------------------------------------------------------------------------
     * Authentication User
     * --------------------------------------------------------------------------
    */

    'username' => env('RVRPC_USERNAME', ''),

    /*
     * --------------------------------------------------------------------------
     * Authentication Password
     * --------------------------------------------------------------------------
    */

    'password' => env('RVRPC_PASSWORD', ''),

    /*
     * --------------------------------------------------------------------------
     * Host Port Number - 0 will use defaults based on ssl
     * --------------------------------------------------------------------------
    */

    'port' => env('RVRPC_PORT', 0),

    /*
     * --------------------------------------------------------------------------
     * If host uses ssl - recommended
     * --------------------------------------------------------------------------
    */

    'ssl' => env('RVRPC_SSL', 0),

    /*
     * --------------------------------------------------------------------------
     * timeout - default 15 seconds
     * --------------------------------------------------------------------------
    */

    'timeout' => env('RVRPC_TIMEOUT', 15),
];
