/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
(function ($, Drupal, drupalSettings, storage) {
  var currentUserID = parseInt(drupalSettings.user.uid, 10);
  var secondsIn30Days = 2592000;
  var thirtyDaysAgo = Math.round(new Date().getTime() / 1000) - secondsIn30Days;
  var embeddedLastReadTimestamps = false;
  if (drupalSettings.history && drupalSettings.history.lastReadTimestamps) {
    embeddedLastReadTimestamps = drupalSettings.history.lastReadTimestamps;
  }
  Drupal.history = {
    fetchTimestamps: function fetchTimestamps(nodeIDs, callback) {
      if (embeddedLastReadTimestamps) {
        callback();
        return;
      }
      $.ajax({
        url: Drupal.url('history/get_node_read_timestamps'),
        type: 'POST',
        data: {
          'node_ids[]': nodeIDs
        },
        dataType: 'json',
        success: function success(results) {
          Object.keys(results || {}).forEach(function (nodeID) {
            storage.setItem("Drupal.history.".concat(currentUserID, ".").concat(nodeID), results[nodeID]);
          });
          callback();
        }
      });
    },
    getLastRead: function getLastRead(nodeID) {
      if (embeddedLastReadTimestamps && embeddedLastReadTimestamps[nodeID]) {
        return parseInt(embeddedLastReadTimestamps[nodeID], 10);
      }
      return parseInt(storage.getItem("Drupal.history.".concat(currentUserID, ".").concat(nodeID)) || 0, 10);
    },
    markAsRead: function markAsRead(nodeID) {
      $.ajax({
        url: Drupal.url("history/".concat(nodeID, "/read")),
        type: 'POST',
        dataType: 'json',
        success: function success(timestamp) {
          if (embeddedLastReadTimestamps && embeddedLastReadTimestamps[nodeID]) {
            return;
          }
          storage.setItem("Drupal.history.".concat(currentUserID, ".").concat(nodeID), timestamp);
        }
      });
    },
    needsServerCheck: function needsServerCheck(nodeID, contentTimestamp) {
      if (contentTimestamp < thirtyDaysAgo) {
        return false;
      }
      if (embeddedLastReadTimestamps && embeddedLastReadTimestamps[nodeID]) {
        return contentTimestamp > parseInt(embeddedLastReadTimestamps[nodeID], 10);
      }
      var minLastReadTimestamp = parseInt(storage.getItem("Drupal.history.".concat(currentUserID, ".").concat(nodeID)) || 0, 10);
      return contentTimestamp > minLastReadTimestamp;
    }
  };
})(jQuery, Drupal, drupalSettings, window.localStorage);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
(function (window, Drupal, drupalSettings) {
  window.addEventListener('load', function () {
    if (drupalSettings.history && drupalSettings.history.nodesToMarkAsRead) {
      Object.keys(drupalSettings.history.nodesToMarkAsRead).forEach(Drupal.history.markAsRead);
    }
  });
})(window, Drupal, drupalSettings);;
{const a=t=>t?typeof t[Symbol.iterator]=="function"?[...t]:[t]:[],f=(t,s)=>{const r=["fontSize"];return s&&r.push("lineHeight"),(o,l=e=>e)=>{t.forEach(e=>{r.filter(n=>n in o).forEach(n=>{e.style[n]=o[n]?`${l(o[n])}px`:""})})}},c=new WeakMap,h=t=>{const s=t<1?"min":"max",r=t<1?Math.max:Math.min;return({fontSize:o,lineHeight:l},e)=>{const n=e[`text_resize_${s}imum`],i={fontSize:r(o*t,n)};return e.text_resize_line_height_allow&&(i.lineHeight=i.fontSize===n?e[`text_resize_line_height_${s}`]:l*t),localStorage.setItem("textResize",JSON.stringify(i)),i}},z={text_resize_increase:h(1.2),text_resize_decrease:h(1/1.2),text_resize_reset:(t,s)=>{const r={fontSize:null};return s.text_resize_line_height_allow&&(r.lineHeight=null),localStorage.removeItem("textResize"),r}};Drupal.behaviors.textResize={attach(t,{text_resize:s={}}){const{text_resize_scope:r,text_resize_line_height_allow:o}=s;let l=[];if(r?l=["getElementById","getElementsByClassName","querySelectorAll"].reduce((e,n)=>e.length?e:a(document[n](r)),l):l=["page","content-inner","#squeeze > #content"].reduce((e,n,i)=>e.length?e:a(document[i===2?"querySelectorAll":"getElementById"](n)),l),l.length){const e=f(l,o);if(typeof localStorage.textResize<"u")try{e(JSON.parse(localStorage.textResize),parseFloat)}catch{}const n=i=>{i.preventDefault();const{currentTarget:g}=i,_=getComputedStyle(l[0]),x=z[g.id]({fontSize:parseFloat(_.fontSize),lineHeight:parseFloat(_.lineHeight)},s);e(x)};once("text-resize","a.changer").forEach(i=>{c.set(i,n),i.addEventListener("click",n)})}},detach(t,s,r){r==="unload"&&once.filter("text-resize","a.changer",t).filter(o=>c.has(o)).forEach(o=>o.removeEventListener("click",c.get(o)))}}}
;
